/*****************************************************************************
*  LPC154x blinky demoprogram for MicroCore100 rev A board
*
*  1. Use SCT3 timer to generate a 100 msec toggle output @ SCT3_OUT0
*  2. SCT3_OUT0 is linked to P0_7 (LED1, toggles every 100 msec)
*****************************************************************************/
#include "LPC15xx.h"

extern void SCT3_Init(void);

volatile uint32_t test;

int main(void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL0 |= EN0_SWM;         // enable the SCT3 clock
    LPC_SWM->PINASSIGN9        |= 0x00FF0000;      // ASSIGN9(23:16) = FF
    LPC_SWM->PINASSIGN9        &= 0xFF07FFFF;      // P0_7 is SCT3_OUT0, ASSIGN9(23:16)
//    LPC_SWM->PINASSIGN9        &= 0xFF18FFFF;      // P0_24 is SCT3_OUT0, ASSIGN9(23:16)

    SCT3_Init();                                   // Initialize SCT3

    while (1) 
    {
        test = LPC_SCT3->STATE_L;                  // unified timer
    }
}
